/*
 * TreeItem.cpp
 *
 *  Created on: 03.11.2009
 *      Author: stefan.detter
 */

#include "TreeItem.h"

#include <QFont>
#include <QPixmap>
#include <QBrush>

TreeItem::TreeItem(TreeItem* parent)
	: QObject(parent)
	, m_parent(parent)
{
	m_treeBoxFont = QFont("Tahoma", 8);
	m_informationBoxFont = QFont("Tahoma", 7);
}

TreeItem::~TreeItem()
{
	/*emit aboutToBeRemoved(this);*/
}


void TreeItem::updateDynamicInfo()
{
	foreach(TreeItem* t, m_children)
	{
        if( t != 0 )
            t->updateDynamicInfo();
	}
}

void TreeItem::clearTags()
{
	foreach(TreeItem* t, m_children)
	{
        if( t != 0 )
            t->clearTags();
	}
}

void TreeItem::inventoryAboutToStart()
{
    foreach(TreeItem* t, m_children)
    {
        if( t != 0 )
            t->inventoryAboutToStart();
    }
}

void TreeItem::inventoryStarted()
{
	foreach(TreeItem* t, m_children)
	{
        if( t != 0 )
            t->inventoryStarted();
	}
}

void TreeItem::inventoryStoped()
{
	foreach(TreeItem* t, m_children)
	{
        if( t != 0 )
            t->inventoryStoped();
	}
}

void TreeItem::inventoryPaused()
{
    foreach(TreeItem* t, m_children)
    {
        if( t != 0 )
            t->inventoryPaused();
    }
}

void TreeItem::inventoryContinued()
{
    foreach(TreeItem* t, m_children)
    {
        if( t != 0 )
            t->inventoryContinued();
    }
}




TreeItem::DISPLAY_TYPE TreeItem::displayType() const
{
	return VALUE;
}

TreeItem* TreeItem::parent() const
{
	return m_parent;
}

int TreeItem::childCount() const
{
	return m_children.size();
}
TreeItem* TreeItem::child(int row) const
{
	return m_children.at(row);
}
int TreeItem::indexOf(TreeItem* t) const
{
	return m_children.indexOf(t);
}

int TreeItem::row() const
{
	return (m_parent != 0) ? m_parent->indexOf((TreeItem*) this) : 0;
}


int TreeItem::informationRowCount () const
{
	return m_informationValues.size();
}

QVariant TreeItem::information (int row, int column, int role) const
{
	switch(role)
	{
		case Qt::DisplayRole:
		{
			switch(column)
			{
			case 0:
				return m_informationKeys.at(row);
			case 1:
				return m_informationValues.at(row);
			}
			break;
		}
		case Qt::TextAlignmentRole:
		{
			if(m_informationHeader.contains(row))
				return int(Qt::AlignHCenter | Qt::AlignVCenter);

			break;
		}

		case Qt::FontRole:
		{
			QFont f = m_informationBoxFont;
			f.setBold(false);
			if(m_informationHeader.contains(row)){
				f.setBold(true);
#ifdef Q_OS_WIN
				f.setPointSize(10);
#else
				f.setPointSize(12);
#endif
                        }
			else if(m_informationSubHeader.contains(row)){
				f.setBold(true);
#ifdef Q_OS_WIN
				f.setPointSize(9);
#else
				f.setPointSize(11);
#endif
			}
			else {
#ifdef Q_OS_WIN
#else
				f.setPointSize(11);
#endif
			}

			return f;
			break;
		}

		case Qt::BackgroundRole:
		{
			if(m_informationHeader.contains(row))
			{
				return headingBackgroundColor();
			}

			if(m_informationSubHeader.contains(row)){
				QLinearGradient lg(0, 0, 0, 45 );
				lg.setColorAt(0, QColor(0x96, 0x99, 0xA2));
				lg.setColorAt(1, Qt::white);
				return QBrush(lg);
			}

			break;
		}

		case Qt::ForegroundRole:
		{
			Qt::GlobalColor color = Qt::black;
			if(m_informationHeader.contains(row)){
				color = Qt::white;
			}
			return QBrush(color);
			break;
		}

	}

	return QVariant();
}

QList<int>	TreeItem::informationSpan() const
{
	return QList<int>() << m_informationHeader << m_informationSubHeader;
}

int TreeItem::progressBarMin() const
{
	return 0;
}
int TreeItem::progressBarMax() const
{
	return 0;
}
QString TreeItem::progressBarText() const
{
	return QString();
}

QBrush TreeItem::headingBackgroundColor() const
{
	if(m_parent != 0)
		return m_parent->headingBackgroundColor();
	else
	{
		QLinearGradient lg(0, 0, 0, 60 );
		lg.setColorAt(0, QColor(0x0C, 0x08, 0x5C));
		lg.setColorAt(1, Qt::white);
		return QBrush(lg);
	}
}

void TreeItem::connectChild(TreeItem* child)
{
	connect(child, SIGNAL(beginInsertRows(TreeItem*,int,int)),
			 this, SIGNAL(beginInsertRows(TreeItem*,int,int)) );

	connect(child, SIGNAL(endInsertRows()),
			 this, SIGNAL(endInsertRows()));

	connect(child, SIGNAL(beginRemoveRows(TreeItem*,int,int)),
			 this, SIGNAL(beginRemoveRows(TreeItem*,int,int)) );

	connect(child, SIGNAL(endRemoveRows()),
			 this, SIGNAL(endRemoveRows()));

	connect(child, SIGNAL(requestToExpand(TreeItem*)),
			 this, SIGNAL(requestToExpand(TreeItem*)) );

	connect(child, SIGNAL(dataChanged(TreeItem*,int,int)),
			 this, SIGNAL(dataChanged(TreeItem*,int,int)) );

	connect(child, SIGNAL(aboutToBeRemoved(TreeItem*)),
			 this, SIGNAL(aboutToBeRemoved(TreeItem*)) );
}

void TreeItem::disconnectChild(TreeItem* child)
{
	disconnect(child, SIGNAL(beginInsertRows(TreeItem*,int,int)),
			   this, SIGNAL(beginInsertRows(TreeItem*,int,int)) );

	disconnect(child, SIGNAL(endInsertRows()),
			    this, SIGNAL(endInsertRows()));

	disconnect(child, SIGNAL(beginRemoveRows(TreeItem*,int,int)),
			    this, SIGNAL(beginRemoveRows(TreeItem*,int,int)) );

	disconnect(child, SIGNAL(endRemoveRows()),
			    this, SIGNAL(endRemoveRows()));

	disconnect(child, SIGNAL(requestToExpand(TreeItem*)),
			    this, SIGNAL(requestToExpand(TreeItem*)) );

	disconnect(child, SIGNAL(dataChanged(TreeItem*,int,int)),
			    this, SIGNAL(dataChanged(TreeItem*,int,int)) );

	disconnect(child, SIGNAL(aboutToBeRemoved(TreeItem*)),
			    this, SIGNAL(aboutToBeRemoved(TreeItem*)) );
}
